// sIFR (Scalable Inman Flash Replacement) version 1.1.3
// Contributions by Mike Davidson, Shaun Inman, and Tomas Jogin
// Associated Article: http://www.mikeindustries.com/blog/archive/2004/08/sifr

/******************************************************************************
 This is the flash detection script.
 ******************************************************************************/
var required = 6;
var hasFlash = false;
if (navigator.appVersion.indexOf("MSIE") != -1 && navigator.appVersion.indexOf("Windows") != -1) {
	document.write('<SCR' + 'IPT LANGUAGE=VBScript\> \n');
	document.write('on error resume next \n');
	document.write('hasFlash = (IsObject(CreateObject("ShockwaveFlash.ShockwaveFlash." & required))) \n');  
	document.write('<'+'/scr' + 'ipt\> \n');
} else {
	var plugin = (navigator.mimeTypes && navigator.mimeTypes["application/x-shockwave-flash"])?navigator.mimeTypes["application/x-shockwave-flash"].enabledPlugin:0;
	if (plugin) {
		var isVersion2 = navigator.plugins["Shockwave Flash 2.0"] ? " 2.0" : "";
		var flashDescription = navigator.plugins["Shockwave Flash" + isVersion2].description;
		var flashVersion = parseInt(flashDescription.charAt(flashDescription.indexOf(".") - 1));
		hasFlash = flashVersion >= required;
	}
}

/******************************************************************************
 This classes the <html> element as `hasFlash` if flash is found. This style
 hook can be used to hide our to-be-replaced content before it even comes down
 the datapipe and eliminate the FOPSC ("Flash of Partially Styled Content")
 
 The lighter the page weight the greater chance of a FOPSC.
 ******************************************************************************/
 
if (hasFlash && document.getElementsByTagName && document.getElementsByTagName('html')[0]) {
	document.getElementsByTagName('html')[0].className += (document.getElementsByTagName('html')[0].className=='')?'hasFlash':' hasFlash';
}	
	
/******************************************************************************
 Some utility functions. Look at them--aren't they useful?
 ******************************************************************************/
 
function SI_normalizeWhiteSpace(txt) {
	var rE = /\s+/gi;
	return txt.replace(rE,' ');
}
function SI_forceRedraw() {
	// Corrects a margin-bottom sum bug in Mozilla
	var d = document;
	if (d.body && d.body.style) {
		d.body.style.height = "1px";
		d.body.style.height = "auto";
	}
}	

/******************************************************************************
 This is the function that finds and replaces the appropriate elements.
 
	elem (string) :
		`div#header` will replace the `div` with the id of header
		`div#primary-content>h1` will replace any `h1` tag whose direct parent is a `div` with an id of `primary-content`
		`h2.replaceme` will replace any `h2` tag with a className of `replaceme`
	swf (string) :
		full path to the swf
	w (number) :
		desired width of Flash movie... use empty single quotes ('') to let the browser decide
	h (number) :
		desired height of Flash movie... use empty single quotes ('') to let the browser decide				
	afv (string) :
		used to pass additional flashVars to the movie (e.g. 'fruit=apple&vegetable=onion')
	textcolor (hexcolor) :
		determines color of headline text in Flash... use empty single quotes ('') to use default black		
	bgcolor (hexcolor or the string 'transparent') :
		determines background color of Flash movie (used in object/embed tags)...
		use empty single quotes ('') to default to none or use ('transparent') for a transparent background		
	 
 The new replaced element will be placed in a div 
 with a className of `'replaced-'+r.e.tagName`
 ******************************************************************************/
 
function TJ_replaceElement(elem,swf,w,h,textcolor,bgcolor,afv) {

	/*
		Author: Tomas Jogin <http://jogin.com/weblog/>
		Description: Iterates through elements, looking for ones to be replaced with flash, see above comment for description on arguments.
	*/

	if (!hasFlash) {
		return;
	}

	var d = document;

	elemarr = elem.split(">");
	
	// PE = Parent Element
	// RE = Element to be Replaced
	PE = new Object();
	RE = new Object();
	
	has_parent = elemarr.length > 1;
	
	// In this loop, attributes are set to RE and PE, respectively, for easier access later on.
	for (i=0; i<elemarr.length; i++)
	{
		es = elemarr[i];
		E = new Object();

		E.id = false;
		E.tagName = false;
		E.className = false;

		if (es.indexOf("#") >= 0) {
			E.id = es.substr(es.indexOf("#")+1, es.length);
			E.tagName = es.substr(0, es.indexOf("#"));
		} else if (es.indexOf(".")>=0) {
			E.className = es.substr(es.indexOf(".")+1, es.length);
			E.tagName = es.substr(0, es.indexOf("."));
		} else {
			E.tagName = es;
		}
		
		if (has_parent && i == 0) {
			PE = E;
		} else {
			RE = E;
		}	
	}


	if (afv != '') {
		afv = SI_normalizeWhiteSpace(afv);
		afv = '&'+afv;
	}

	// retrieves all elements of the type we want to replace
	var elems = d.getElementsByTagName(RE.tagName);
	var count = elems.length;

	if (!count) {
		return;
	}	
	
	i = 0;
	
	switches = 0;
	skips = 0;
	total = count;

		if (!h) {
			var noheight = true;
		}
		if (!w) {
			var nowidth = true;
		}

	while (count)
	{
		// retrieve element from element collection
		e = elems[i];
		i++;

		// checks to see if the element we've got is one we want to replace, if it is not, it is skipped and the loop resumes from the beginning
		if (has_parent) {
			if (PE.className) {
				if (PE.className != e.parentNode.className) {
					count--; skips++; continue;
				}	
				if (PE.id) {
					if (PE.id != e.parentNode.id) {
						count--; skips++; continue;
					}
				}
			}		
		}
		
		// another check to see if the element we've got is one we want to replace, if it is not, it is skipped and the loop resumes from the beginning
		if (RE.className) {
			if (e.className != RE.className) {
				count--; skips++; continue;
			}
			if (RE.id) {
				if(e.id != RE.id) {
					count--; skips++; continue;
				}
			}
		}

		/*
			Redundant safety measure. If an element has the attribute "ifrskip", we skip it.
			However, because we skip over that element entirely further down (with the i++ statement),
			it will probably never be required.
		*/
		if(e.getAttribute("ifrskip"))
		{	continue;	}

		if (noheight) {
			h = e.offsetHeight;
		}
		if (nowidth) {
			w = e.offsetWidth;
		}
		
		var txt;
		txt = SI_normalizeWhiteSpace(e.innerHTML);
		
		/*	creates a new element, a div, regardless of what type of element we're replacing.
			we give that div a class name of "replaced-<tag name>".
			for instance, if an H2 is to be replaced with flash, it will be replaced with a <div class="replaced-h2">
		*/
		var c = d.createElement('div');
		c.className = 'replaced-'+RE.tagName;
		e.parentNode.replaceChild(c,e);
		
		/*
			Since we're replacing all elements with div-elements,
			the amount of the elements we're iterating through will change as we go.
			
			To make the flash replacements printer-friendly,
			we're also inserting another identical element to the one we're replacing with a div.
			(Look further down, below the insertion of the <object> stuff)
			
			So, if the element we're replacing is a H2 we should just do nothing; we replace it with a div,
			but we also put it right back afterwards.
			If we, on the other hand, are replacing a DIV, there will be another element of the same kind added,
			and we need to skip over it, or we'll be stuck here for eternity.
		*/
		if(RE.tagName == "div")
			i++;

		/* This loop uses count to determine when we're done. */	
		count--;
		/* Redundant debug data, counts the amount of switches carried out. */
		switches++;

		/* Prepares parameters to be passed to Flash */
		var wmode = (bgcolor == 'transparent') ? 'transparent' : 'opaque';
		var fv = 'txt='+escape(txt)+afv+'&w='+w+'&h='+h+'&textcolor='+textcolor;
		
		/* This is the stuff we insert into the DIV, which replaces whatever type of element we want to replace */
		var swfHTML;
		swfHTML  = '<object class="sIFRobject" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=6,0,0,0" width="'+w+'" height="'+h+'">';
		swfHTML += '	<param name="movie" value="'+swf+'" />';
		swfHTML += '	<param name="wmode" value="'+wmode+'" />';		
		swfHTML += '	<param name="bgcolor" value="'+bgcolor+'" />';		
		swfHTML += '	<param name="flashvars" value="'+fv+'" />';
		swfHTML += '	<embed class="sIFRobject" src="'+swf+'" flashvars="'+fv+'" width="'+w+'" height="'+h+'" TYPE="application/x-shockwave-flash" PLUGINSPAGE="http://www.macromedia.com/go/getflashplayer" wmode="'+wmode+'" bgcolor="'+bgcolor+'" />';
		swfHTML += '<'+'/object>';
		swfHTML += '<'+e.nodeName.toLowerCase()+((e.id)?' id="'+e.id+'"':'')+((e.className)?' class="'+e.className+'"':'')+' style="display: none" ifrskip="1">'+txt+'<'+'/'+e.nodeName.toLowerCase()+'>';
		c.innerHTML = swfHTML;
		txt='';
	}

}

function sIFR () {

	// Parameters: item_to_replace , swf_filename, width, height, textcolor, bgcolor, additional_vars
	// All are optional except first two parameters
	
	TJ_replaceElement('h1','sIFR.swf','','','#990000','#FFFFFF','');
	TJ_replaceElement('h2.replace','sIFR.swf','','','#002D6F','#FFFFFF','');
	TJ_replaceElement('div.replace','sIFR.swf','','','#2D6F00','#FFFFFF','');
	
	SI_forceRedraw();
}

window.onload=sIFR;